/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterTextNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFormatterNodeBuilder {
    private final Stack<IFormatterContainerNode> stack = new Stack();
    private static final Pattern COMMENT_PREFIX = Pattern.compile("^\\s*(//|/\\*|#|<!--).*", 32);
    protected List<IRegion> onOffRegions;

    protected void start(IFormatterContainerNode root) {
        this.stack.clear();
        this.stack.push(root);
    }

    public IFormatterContainerNode peek() {
        return this.stack.peek();
    }

    public void push(IFormatterContainerNode node) {
        this.addChild(node);
        this.stack.push(node);
    }

    public IFormatterNode addChild(IFormatterNode node) {
        IFormatterContainerNode parentNode = this.peek();
        if (!node.isEmpty()) {
            this.advanceParent(node, parentNode, node.getStartOffset());
        }
        parentNode.addChild(node);
        return node;
    }

    public List<IRegion> getOffOnRegions() {
        return this.onOffRegions;
    }

    protected void setOffOnRegions(List<IRegion> regions) {
        this.onOffRegions = regions;
    }

    protected List<IRegion> resolveOffOnRegions(IParseRootNode parseNode, IFormatterDocument document, String offOnEnablementKey, String offPatternKey, String onPatternKey) {
        if (!document.getBoolean(offOnEnablementKey)) {
            return null;
        }
        IParseNode[] commentNodes = parseNode.getCommentNodes();
        if (commentNodes == null || commentNodes.length == 0) {
            return null;
        }
        LinkedHashMap<Integer, String> commentsMap = new LinkedHashMap<Integer, String>(commentNodes.length);
        IParseNode[] iParseNodeArray = commentNodes;
        int n = commentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode comment = iParseNodeArray[n2];
            int start = comment.getStartingOffset();
            int end = comment.getEndingOffset();
            String commentStr = document.get(start, end);
            commentsMap.put(start, commentStr);
            ++n2;
        }
        if (!commentsMap.isEmpty()) {
            Pattern onPattern = Pattern.compile(Pattern.quote(document.getString(onPatternKey)));
            Pattern offPattern = Pattern.compile(Pattern.quote(document.getString(offPatternKey)));
            return FormatterUtils.resolveOnOffRegions(commentsMap, onPattern, offPattern, document.getLength() - 1);
        }
        return null;
    }

    private void advanceParent(IFormatterNode node, IFormatterContainerNode parentNode, int pos) {
        int startOffset = parentNode.getEndOffset();
        if (startOffset < pos) {
            String trimmedText;
            IFormatterDocument document = parentNode.getDocument();
            String text = document.get(startOffset, pos);
            if (node.shouldConsumePreviousWhiteSpaces()) {
                List<IFormatterNode> children = parentNode.getChildren();
                int preservedSpaces = 0;
                if (!children.isEmpty()) {
                    preservedSpaces = children.get(children.size() - 1).getSpacesCountAfter();
                }
                if (text.trim().length() == 0 && preservedSpaces == 0) {
                    return;
                }
                int rightPos = text.length() - 1;
                while (rightPos > 0) {
                    if (!Character.isWhitespace(text.charAt(rightPos))) break;
                    --rightPos;
                }
                int newPos = Math.max(startOffset, pos - (text.length() - rightPos + preservedSpaces) + 1);
                if (newPos < pos && preservedSpaces > 0 && !Character.isWhitespace(document.charAt(newPos))) {
                    newPos = pos;
                }
                pos = newPos;
            }
            if (COMMENT_PREFIX.matcher(trimmedText = text.trim()).matches()) {
                while ((document.charAt(startOffset) == ' ' || document.charAt(startOffset) == '\t') && startOffset < pos - 1) {
                    ++startOffset;
                }
                if (trimmedText.startsWith("/*") && trimmedText.endsWith("*/") || trimmedText.startsWith("<!--") && trimmedText.endsWith("-->")) {
                    while ((document.charAt(pos - 1) == ' ' || document.charAt(pos - 1) == '\t') && startOffset < pos - 1) {
                        --pos;
                    }
                }
            }
            parentNode.addChild(AbstractFormatterNodeBuilder.createTextNode(document, startOffset, pos));
        }
    }

    public static int locateCharacterSkippingWhitespaces(FormatterDocument document, int startOffset, char c, boolean caseSensitive) {
        char toCheck = caseSensitive ? c : Character.toLowerCase(c);
        int i = startOffset;
        while (i < document.getLength()) {
            char next = document.charAt(i);
            if (!caseSensitive) {
                next = Character.toLowerCase(next);
            }
            if (toCheck == next) {
                startOffset = i;
                break;
            }
            if (!Character.isWhitespace(next)) break;
            ++i;
        }
        return startOffset;
    }

    public int getNextNonWhiteCharOffset(FormatterDocument document, int startOffset) {
        int length = document.getLength();
        int offset = startOffset;
        while (offset < length) {
            char charAt = document.charAt(offset);
            if (!Character.isWhitespace(charAt)) {
                return offset;
            }
            ++offset;
        }
        return startOffset;
    }

    public void checkedPop(IFormatterContainerNode expected, int bodyEnd) {
        IFormatterContainerNode top = this.stack.pop();
        if (top != expected) {
            throw new IllegalStateException();
        }
        if (bodyEnd > 0 && expected.getEndOffset() < bodyEnd) {
            expected.addChild(AbstractFormatterNodeBuilder.createTextNode(expected.getDocument(), expected.getEndOffset(), bodyEnd));
        }
    }

    public static IFormatterTextNode createTextNode(IFormatterDocument document, int startIndex, int endIndex) {
        return new FormatterTextNode(document, startIndex, endIndex);
    }

    public static int locateCharBackward(FormatterDocument document, char c, int start) {
        int offset = start;
        while (offset >= 0) {
            if (document.charAt(offset) == c) {
                return offset;
            }
            --offset;
        }
        return start;
    }

    public static int locateCharForward(FormatterDocument document, char c, int start) {
        int length = document.getLength();
        int offset = start;
        while (offset < length) {
            if (document.charAt(offset) == c) {
                return offset;
            }
            ++offset;
        }
        return start;
    }
}

